function energy = groPipeEnergy(dT)
%GROPIPEENERGY Calculate the energy input to the grow pipes in a compartment in Wageningen Greenhouse Horticulture, Bleiswijk
% input:
%   dT - difference between air and grow pipe temperature (C)
% output:
%   energy - energy input from the pipe (W m^{-2})
% Constants used below are only relevant for a 144 m^{2} compartment in 
% Wageningen Greenhouse Horticulture, Bleiswijk

% David Katzin, Wageningen University
% david.katzin@wur.nl

    energy = 1/144*(pipeT2EnergyIn(35,dT,94.5)+pipeT2EnergyIn(29,dT,70)+...
        pipeT2EnergyIn(64,dT,9.4)+pipeT2EnergyIn(51,dT,37));
end